


 /**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       The main Code's c file.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2023/06/14
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "MG32x02z_Global.h"
#include "MG32x02z_MEM_DRV.h"
#include "MG32x02z_USBD_Keyboard_API.h"
#include "MG32x02z_RGB_API.h"
#include "MG32x02z_USBD_EasyCOM_API.h"
#include "MG32x02z_USBD_EasyHID_API.h"
#include "MG32x02z_URT.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    Main function in the project.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
int main(void)
{
    //==========================================
    //IC hardware initial (ChipInit_Wizard)
    UnProtectModuleReg(MEMprotect);
    MEM->CR0.MBIT.FWAIT  = 1;
    MEM->CR0.MBIT.HSP_EN = 1;
    ProtectModuleReg(MEMprotect);
    
    
    MCU_Init();
    
    //=========================================
    //Main code loop
    while(1)
    {
        API_KB_Main();
        
        #if MG32x02z_USBD_KEYBOARD_RGB_EN != API_RGB_DISABLE
            API_RGB_Main();
        #endif
        if(EasyCOM_Flag==1)
        {
            EasyCOM_Flag = 0;
            API_USBD_COM_main();
        }
    }
}     


